#include "font_manager.h"
#include <sms.h>

// Private helper method.
static void engine_font_manager_draw_format(unsigned int data, unsigned char x, unsigned char y, unsigned char len);

const unsigned char engine_font_manager_data_tiles[] =
{
0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00,
0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x24, 0x24, 0x24, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x7F, 0x7F, 0x7F, 0x7F, 0x36, 0x36, 0x36, 0x36, 0x7F, 0x7F, 0x7F, 0x7F, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00,
0x08, 0x08, 0x08, 0x08, 0x3E, 0x3E, 0x3E, 0x3E, 0x68, 0x68, 0x68, 0x68, 0x3E, 0x3E, 0x3E, 0x3E, 0x0B, 0x0B, 0x0B, 0x0B, 0x3E, 0x3E, 0x3E, 0x3E, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00,
0x21, 0x21, 0x21, 0x21, 0x52, 0x52, 0x52, 0x52, 0x24, 0x24, 0x24, 0x24, 0x08, 0x08, 0x08, 0x08, 0x12, 0x12, 0x12, 0x12, 0x25, 0x25, 0x25, 0x25, 0x42, 0x42, 0x42, 0x42, 0x00, 0x00, 0x00, 0x00,
0x18, 0x18, 0x18, 0x18, 0x24, 0x24, 0x24, 0x24, 0x34, 0x34, 0x34, 0x34, 0x38, 0x38, 0x38, 0x38, 0x4D, 0x4D, 0x4D, 0x4D, 0x46, 0x46, 0x46, 0x46, 0x3D, 0x3D, 0x3D, 0x3D, 0x00, 0x00, 0x00, 0x00,
0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x10, 0x10, 0x10, 0x10, 0x20, 0x20, 0x20, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x0C, 0x0C, 0x0C, 0x0C, 0x18, 0x18, 0x18, 0x18, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x18, 0x18, 0x18, 0x18, 0x0C, 0x0C, 0x0C, 0x0C, 0x00, 0x00, 0x00, 0x00,
0x18, 0x18, 0x18, 0x18, 0x0C, 0x0C, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0C, 0x0C, 0x0C, 0x0C, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x22, 0x22, 0x22, 0x22, 0x14, 0x14, 0x14, 0x14, 0x08, 0x08, 0x08, 0x08, 0x14, 0x14, 0x14, 0x14, 0x22, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x3E, 0x3E, 0x3E, 0x3E, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x30, 0x30, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3E, 0x3E, 0x3E, 0x3E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00,
0x01, 0x01, 0x01, 0x01, 0x02, 0x02, 0x02, 0x02, 0x04, 0x04, 0x04, 0x04, 0x08, 0x08, 0x08, 0x08, 0x10, 0x10, 0x10, 0x10, 0x20, 0x20, 0x20, 0x20, 0x40, 0x40, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00,
0x1C, 0x1C, 0x1C, 0x1C, 0x26, 0x26, 0x26, 0x26, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x32, 0x32, 0x32, 0x32, 0x1C, 0x1C, 0x1C, 0x1C, 0x00, 0x00, 0x00, 0x00,
0x0C, 0x0C, 0x0C, 0x0C, 0x1C, 0x1C, 0x1C, 0x1C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x3F, 0x3F, 0x3F, 0x3F, 0x00, 0x00, 0x00, 0x00,
0x3E, 0x3E, 0x3E, 0x3E, 0x63, 0x63, 0x63, 0x63, 0x07, 0x07, 0x07, 0x07, 0x1E, 0x1E, 0x1E, 0x1E, 0x3C, 0x3C, 0x3C, 0x3C, 0x70, 0x70, 0x70, 0x70, 0x7F, 0x7F, 0x7F, 0x7F, 0x00, 0x00, 0x00, 0x00,
0x3F, 0x3F, 0x3F, 0x3F, 0x06, 0x06, 0x06, 0x06, 0x0C, 0x0C, 0x0C, 0x0C, 0x1E, 0x1E, 0x1E, 0x1E, 0x03, 0x03, 0x03, 0x03, 0x63, 0x63, 0x63, 0x63, 0x3E, 0x3E, 0x3E, 0x3E, 0x00, 0x00, 0x00, 0x00,
0x0E, 0x0E, 0x0E, 0x0E, 0x1E, 0x1E, 0x1E, 0x1E, 0x36, 0x36, 0x36, 0x36, 0x66, 0x66, 0x66, 0x66, 0x7F, 0x7F, 0x7F, 0x7F, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00,
0x7E, 0x7E, 0x7E, 0x7E, 0x60, 0x60, 0x60, 0x60, 0x7E, 0x7E, 0x7E, 0x7E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x63, 0x63, 0x63, 0x63, 0x3E, 0x3E, 0x3E, 0x3E, 0x00, 0x00, 0x00, 0x00,
0x1E, 0x1E, 0x1E, 0x1E, 0x30, 0x30, 0x30, 0x30, 0x60, 0x60, 0x60, 0x60, 0x7E, 0x7E, 0x7E, 0x7E, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x3E, 0x3E, 0x3E, 0x3E, 0x00, 0x00, 0x00, 0x00,
0x7F, 0x7F, 0x7F, 0x7F, 0x63, 0x63, 0x63, 0x63, 0x06, 0x06, 0x06, 0x06, 0x0C, 0x0C, 0x0C, 0x0C, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00,
0x3C, 0x3C, 0x3C, 0x3C, 0x62, 0x62, 0x62, 0x62, 0x72, 0x72, 0x72, 0x72, 0x3C, 0x3C, 0x3C, 0x3C, 0x4F, 0x4F, 0x4F, 0x4F, 0x43, 0x43, 0x43, 0x43, 0x3E, 0x3E, 0x3E, 0x3E, 0x00, 0x00, 0x00, 0x00,
0x3E, 0x3E, 0x3E, 0x3E, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x3F, 0x3F, 0x3F, 0x3F, 0x03, 0x03, 0x03, 0x03, 0x06, 0x06, 0x06, 0x06, 0x3C, 0x3C, 0x3C, 0x3C, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x30, 0x30, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00,
0x06, 0x06, 0x06, 0x06, 0x0C, 0x0C, 0x0C, 0x0C, 0x18, 0x18, 0x18, 0x18, 0x30, 0x30, 0x30, 0x30, 0x18, 0x18, 0x18, 0x18, 0x0C, 0x0C, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3E, 0x3E, 0x3E, 0x3E, 0x00, 0x00, 0x00, 0x00, 0x3E, 0x3E, 0x3E, 0x3E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x30, 0x30, 0x30, 0x30, 0x18, 0x18, 0x18, 0x18, 0x0C, 0x0C, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x06, 0x0C, 0x0C, 0x0C, 0x0C, 0x18, 0x18, 0x18, 0x18, 0x30, 0x30, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00,
0x3E, 0x3E, 0x3E, 0x3E, 0x7F, 0x7F, 0x7F, 0x7F, 0x63, 0x63, 0x63, 0x63, 0x06, 0x06, 0x06, 0x06, 0x1C, 0x1C, 0x1C, 0x1C, 0x00, 0x00, 0x00, 0x00, 0x1C, 0x1C, 0x1C, 0x1C, 0x00, 0x00, 0x00, 0x00,
0x1E, 0x1E, 0x1E, 0x1E, 0x33, 0x33, 0x33, 0x33, 0x67, 0x67, 0x67, 0x67, 0x67, 0x67, 0x67, 0x67, 0x60, 0x60, 0x60, 0x60, 0x33, 0x33, 0x33, 0x33, 0x1E, 0x1E, 0x1E, 0x1E, 0x00, 0x00, 0x00, 0x00,
0x1C, 0x1C, 0x1C, 0x1C, 0x36, 0x36, 0x36, 0x36, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x7F, 0x7F, 0x7F, 0x7F, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00,
0x7E, 0x7E, 0x7E, 0x7E, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x7E, 0x7E, 0x7E, 0x7E, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x7E, 0x7E, 0x7E, 0x7E, 0x00, 0x00, 0x00, 0x00,
0x1E, 0x1E, 0x1E, 0x1E, 0x33, 0x33, 0x33, 0x33, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x33, 0x33, 0x33, 0x33, 0x1E, 0x1E, 0x1E, 0x1E, 0x00, 0x00, 0x00, 0x00,
0x7C, 0x7C, 0x7C, 0x7C, 0x66, 0x66, 0x66, 0x66, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x66, 0x66, 0x66, 0x66, 0x7C, 0x7C, 0x7C, 0x7C, 0x00, 0x00, 0x00, 0x00,
0x7F, 0x7F, 0x7F, 0x7F, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x7E, 0x7E, 0x7E, 0x7E, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x7F, 0x7F, 0x7F, 0x7F, 0x00, 0x00, 0x00, 0x00,
0x7F, 0x7F, 0x7F, 0x7F, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x7E, 0x7E, 0x7E, 0x7E, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00,
0x1F, 0x1F, 0x1F, 0x1F, 0x30, 0x30, 0x30, 0x30, 0x60, 0x60, 0x60, 0x60, 0x67, 0x67, 0x67, 0x67, 0x63, 0x63, 0x63, 0x63, 0x33, 0x33, 0x33, 0x33, 0x1F, 0x1F, 0x1F, 0x1F, 0x00, 0x00, 0x00, 0x00,
0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x7F, 0x7F, 0x7F, 0x7F, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00,
0x3F, 0x3F, 0x3F, 0x3F, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x3F, 0x3F, 0x3F, 0x3F, 0x00, 0x00, 0x00, 0x00,
0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x63, 0x63, 0x63, 0x63, 0x3E, 0x3E, 0x3E, 0x3E, 0x00, 0x00, 0x00, 0x00,
0x63, 0x63, 0x63, 0x63, 0x66, 0x66, 0x66, 0x66, 0x6C, 0x6C, 0x6C, 0x6C, 0x78, 0x78, 0x78, 0x78, 0x7C, 0x7C, 0x7C, 0x7C, 0x6E, 0x6E, 0x6E, 0x6E, 0x67, 0x67, 0x67, 0x67, 0x00, 0x00, 0x00, 0x00,
0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x7F, 0x7F, 0x7F, 0x7F, 0x00, 0x00, 0x00, 0x00,
0x63, 0x63, 0x63, 0x63, 0x77, 0x77, 0x77, 0x77, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x6B, 0x6B, 0x6B, 0x6B, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00,
0x63, 0x63, 0x63, 0x63, 0x73, 0x73, 0x73, 0x73, 0x7B, 0x7B, 0x7B, 0x7B, 0x7F, 0x7F, 0x7F, 0x7F, 0x6F, 0x6F, 0x6F, 0x6F, 0x67, 0x67, 0x67, 0x67, 0x63, 0x63, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00,
0x3E, 0x3E, 0x3E, 0x3E, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x3E, 0x3E, 0x3E, 0x3E, 0x00, 0x00, 0x00, 0x00,
0x7E, 0x7E, 0x7E, 0x7E, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x7E, 0x7E, 0x7E, 0x7E, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00,
0x3E, 0x3E, 0x3E, 0x3E, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x6F, 0x6F, 0x6F, 0x6F, 0x66, 0x66, 0x66, 0x66, 0x3D, 0x3D, 0x3D, 0x3D, 0x00, 0x00, 0x00, 0x00,
0x7E, 0x7E, 0x7E, 0x7E, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x67, 0x67, 0x67, 0x67, 0x7C, 0x7C, 0x7C, 0x7C, 0x6E, 0x6E, 0x6E, 0x6E, 0x67, 0x67, 0x67, 0x67, 0x00, 0x00, 0x00, 0x00,
0x3C, 0x3C, 0x3C, 0x3C, 0x66, 0x66, 0x66, 0x66, 0x60, 0x60, 0x60, 0x60, 0x3E, 0x3E, 0x3E, 0x3E, 0x03, 0x03, 0x03, 0x03, 0x63, 0x63, 0x63, 0x63, 0x3E, 0x3E, 0x3E, 0x3E, 0x00, 0x00, 0x00, 0x00,
0x3F, 0x3F, 0x3F, 0x3F, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x00, 0x00, 0x00, 0x00,
0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x3E, 0x3E, 0x3E, 0x3E, 0x00, 0x00, 0x00, 0x00,
0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x77, 0x77, 0x77, 0x77, 0x3E, 0x3E, 0x3E, 0x3E, 0x1C, 0x1C, 0x1C, 0x1C, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00,
0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x6B, 0x6B, 0x6B, 0x6B, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x77, 0x77, 0x77, 0x77, 0x63, 0x63, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00,
0x63, 0x63, 0x63, 0x63, 0x77, 0x77, 0x77, 0x77, 0x3E, 0x3E, 0x3E, 0x3E, 0x1C, 0x1C, 0x1C, 0x1C, 0x3E, 0x3E, 0x3E, 0x3E, 0x77, 0x77, 0x77, 0x77, 0x63, 0x63, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00,
0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x1E, 0x1E, 0x1E, 0x1E, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x00, 0x00, 0x00, 0x00,
0x7F, 0x7F, 0x7F, 0x7F, 0x07, 0x07, 0x07, 0x07, 0x0E, 0x0E, 0x0E, 0x0E, 0x1C, 0x1C, 0x1C, 0x1C, 0x38, 0x38, 0x38, 0x38, 0x70, 0x70, 0x70, 0x70, 0x7F, 0x7F, 0x7F, 0x7F, 0x00, 0x00, 0x00, 0x00,
0x1E, 0x1E, 0x1E, 0x1E, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x1E, 0x1E, 0x1E, 0x1E, 0x00, 0x00, 0x00, 0x00,
0x40, 0x40, 0x40, 0x40, 0x20, 0x20, 0x20, 0x20, 0x10, 0x10, 0x10, 0x10, 0x08, 0x08, 0x08, 0x08, 0x04, 0x04, 0x04, 0x04, 0x02, 0x02, 0x02, 0x02, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00,
0x3C, 0x3C, 0x3C, 0x3C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x3C, 0x3C, 0x3C, 0x3C, 0x00, 0x00, 0x00, 0x00,
0x08, 0x08, 0x08, 0x08, 0x14, 0x14, 0x14, 0x14, 0x2A, 0x2A, 0x2A, 0x2A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7F, 0x7F, 0x7F, 0x7F,
0x08, 0x08, 0x08, 0x08, 0x04, 0x04, 0x04, 0x04, 0x0A, 0x0A, 0x0A, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};

const unsigned int engine_font_manager_data_tilemap[] =
{
0x00C0, 0x00C1, 0x00C2, 0x00C3, 0x00C4, 0x00C5, 0x00C6, 0x00C7, 0x00C8, 0x00C9, 0x00CA, 0x00CB, 0x00CC, 0x00CD, 0x00CE, 0x00CF, 0x00D0, 0x00D1, 0x00D2, 0x00D3, 0x00D4, 0x00D5, 0x00D6, 0x00D7, 0x00D8, 0x00D9, 0x00DA, 0x00DB, 0x00DC, 0x00DD, 0x00DE, 0x00DF, 0x00E0, 0x00E1, 0x00E2, 0x00E3, 0x00E4, 0x00E5, 0x00E6, 0x00E7, 0x00E8, 0x00E9, 0x00EA, 0x00EB, 0x00EC, 0x00ED, 0x00EE, 0x00EF, 0x00F0, 0x00F1, 0x00F2, 0x00F3, 0x00F4, 0x00F5, 0x00F6, 0x00F7, 0x00F8, 0x00F9, 0x00FA, 0x00FB, 0x00FC, 0x00FD, 0x00FE, 0x00FF,	
};

void engine_font_manager_load()
{
	load_tiles(engine_font_manager_data_tiles, 192, 64, 4);			// SMS.
}

void engine_font_manager_draw_text(unsigned char* text, unsigned char x, unsigned char y)
{
	int idx=0, len=0;
	while (text[len] != '\0')
	{
		++len;
	}
	for (idx = 0; idx < len; ++idx)
	{
		char lett = text[idx];
		char loop = lett - 33;			// 33 is "!" in ASCII.

		set_bkg_map(&engine_font_manager_data_tilemap[loop], x++, y, 1, 1);		// SMS.
	}
}

void engine_font_manager_draw_data(unsigned int data, unsigned char x, unsigned char y)
{
	engine_font_manager_draw_format(data, x, y, 0);
}
void engine_font_manager_draw_score(unsigned int data, unsigned char x, unsigned char y)
{
	engine_font_manager_draw_format(data, x, y, MAX_LENGTH);
}
static void engine_font_manager_draw_format(unsigned int data, unsigned char x, unsigned char y, unsigned char len)
{
	unsigned char c, idx, tmp, units;
	char place[MAX_LENGTH];
	tmp = 0;
	units = 10;

	for (idx = 0; idx < MAX_LENGTH; ++idx)
	{
		place[idx] = 0;
	}


	for (idx = 0; idx < MAX_LENGTH; ++idx)
	{
		if (0 == len)
		{
			if (data > 0)
			{
				tmp++;
			}
		}

		place[idx] = data % units;
		data /= units;
	}


	c = place[0];
	c+= 15;			// 15 is "0" (48) - "!" (33) = 15 equals index 0.
	set_bkg_map(&engine_font_manager_data_tilemap[c], x--, y, 1, 1);			// SMS.


	len = (0 == len) ? tmp : MAX_LENGTH;
	for (idx = 1; idx < len; ++idx)
	{
		c = place[idx];
		c+= 15;
		set_bkg_map(&engine_font_manager_data_tilemap[c], x--, y, 1, 1);		// SMS.
	}
}
